/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 1.22)
 *
 *  Wersja "sprytniejsza", zawierajca struktury rekurencyjne,
 *  zasugerowana przez Eggerta, Resslera, Volpe'a i wielu innych.
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdio.h>

#ifdef __STDC__
void statemachine(void);
#endif
void statemachine();

main()
{
statemachine();
return 0;
}

struct functhunk {
	struct functhunk (*func)();
};

struct functhunk start(), stop();
struct functhunk state1(), state2(), state3();

void statemachine()
{
	struct functhunk state = {start};

	while(state.func != stop)
#ifdef oldway
		state = (*state.func)();
#else
		state = state.func();
#endif
}

static int count;


struct functhunk start()
{
	struct functhunk ret;
	count = 0;
	ret.func = state1;
	return ret;
}

struct functhunk state1()
{
struct functhunk ret;
printf("Stan nr 1\n");
ret.func = state2;
return ret;
}

struct functhunk state2()
{
struct functhunk ret;
printf("Stan nr 2\n");
ret.func = state3;
return ret;
}

struct functhunk state3()
{
struct functhunk ret;
count++;
printf("Stan nr 3\n");
ret.func = (count < 3) ? state1 : stop;
return ret;
}

struct functhunk stop()
{
printf("Koniec\n");
exit(1);
}
